#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<time.h>
#include<pthread.h>

#define N 10
#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

pthread_mutex_t mutex;
pthread_cond_t cond;

int daLiJeNaNadvozKamion = 0; //0 - nije, 1 - jeste
int daLiJeNaNadvozAutobus = 0; //0 - nije, 1 - jeste

int brojSaSevera = 0;
int brojSaJuga = 0;

void *vozilaJug(void *arg)
{
    long id = (long)arg;
    int vremeDolaska = srand(5);
    int tip = rand() % 3; // 0 - auto,1 - autobus,2 - kamion

    sleep(vremeDolaska);
    printf("Vozilo %ld tipa %d dolazi do nadvoznjaka sa juga u trenutku %d.\n",id,tip,vremeDolaska);
    
    if(tip == AUTO)
    {
        pthread_mutex_lock(&mutex);

        while(daLiJeNaNadvozKamion == 1 || brojSaSevera > 0)
            pthread_cond_wait(&cond,&mutex);

        brojSaJuga++;
        pthread_mutex_unlock(&mutex);

        sleep(2);
        printf("Vozilo %ld tipa AUTO sa juga prelazi nadvoznjak.\n",id);

        pthread_mutex_lock(&mutex);
        brojSaJuga--;
        pthread_mutex_unlock(&mutex);
        pthread_cond_broadcast(&cond);
    }
    else if(tip == AUTOBUS)
    {
        pthread_mutex_lock(&mutex);

        while(daLiJeNaNadvozKamion == 1 || brojSaSevera > 0 || daLiJeNaNadvozAutobus == 1)
            pthread_cond_wait(&cond,&mutex);

        brojSaJuga++;
        daLiJeNaNadvozAutobus = 1;
        pthread_mutex_unlock(&mutex);

        sleep(2);
        printf("Vozilo %ld tipa AUTOBUS sa juga prelazi nadvoznjak.\n",id);

        pthread_mutex_lock(&mutex);
        brojSaJuga--;
        daLiJeNaNadvozAutobus = 0;
        pthread_mutex_unlock(&mutex);
        pthread_cond_broadcast(&cond);
    }
    else
    {
        pthread_mutex_lock(&mutex);

        while(brojSaSevera > 0 || brojSaJuga > 0) //ne sme da bude niko na nadvoznjaku nebitno iz kog smera
            pthread_cond_wait(&cond,&mutex);

        brojSaJuga++;
        daLiJeNaNadvozKamion = 1;
        pthread_mutex_unlock(&mutex);

        sleep(2);
        printf("Vozilo %ld tipa KAMION sa juga prelazi nadvoznjak.\n",id);

        pthread_mutex_lock(&mutex);
        brojSaJuga--;
        daLiJeNaNadvozKamion = 0;
        pthread_mutex_unlock(&mutex);
        pthread_cond_broadcast(&cond);
    }

}

void *vozilaSever(void *arg)
{
    long id = (long)arg;
    int vremeDolaska = srand(5);
    int tip = rand() % 3; // 0 - auto,1 - autobus,2 - kamion

    sleep(vremeDolaska);
    printf("Vozilo %ld tipa %d dolazi do nadvoznjaka sa severa u trenutku %d.",id,tip,vremeDolaska);
    
    if(tip == AUTO)
    {
        pthread_mutex_lock(&mutex);

        while(daLiJeNaNadvozKamion == 1 || brojSaJuga > 0)
            pthread_cond_wait(&cond,&mutex);

        brojSaSevera++;
        pthread_mutex_unlock(&mutex);

        sleep(2);
        printf("Vozilo %ld tipa AUTO sa severa prelazi nadvoznjak.\n",id);

        pthread_mutex_lock(&mutex);
        brojSaSevera--;
        pthread_mutex_unlock(&mutex);
        pthread_cond_broadcast(&cond);
    }
    else if(tip == AUTOBUS)
    {
        pthread_mutex_lock(&mutex);

        while(daLiJeNaNadvozKamion == 1 || brojSaJuga > 0 || daLiJeNaNadvozAutobus == 1)
            pthread_cond_wait(&cond,&mutex);

        brojSaSevera++;
        daLiJeNaNadvozAutobus = 1;
        pthread_mutex_unlock(&mutex);

        sleep(2);
        printf("Vozilo %ld tipa AUTOBUS sa severa prelazi nadvoznjak.\n",id);

        pthread_mutex_lock(&mutex);
        brojSaSevera--;
        daLiJeNaNadvozAutobus = 0;
        pthread_mutex_unlock(&mutex);
        pthread_cond_broadcast(&cond);
    }
    else
    {
        pthread_mutex_lock(&mutex);

        while(brojSaSevera > 0 || brojSaJuga > 0) //ne sme da bude niko na nadvoznjaku
            pthread_cond_wait(&cond,&mutex);

        brojSaSevera++;
        daLiJeNaNadvozKamion = 1;
        pthread_mutex_unlock(&mutex);

        sleep(2);
        printf("Vozilo %ld tipa KAMION sa severa prelazi nadvoznjak.\n",id);

        pthread_mutex_lock(&mutex);
        brojSaSevera--;
        daLiJeNaNadvozKamion = 0;
        pthread_mutex_unlock(&mutex);
        pthread_cond_broadcast(&cond);
    }
}

int main()
{
    long i;
    pthread_t vozila[N];
    int strana; //0 - jug,1 - sever

    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&cond,NULL);

    for(i=0;i<N;i++)
    {
        strana = rand() % 2;
        if(strana == 0)
            pthread_create(vozila[i],NULL,vozilaJug,(void *)i);
        else
            pthread_create(vozila[i],NULL,vozilaSever,(void *)i);
    }

    for(i=0;i<N;i++)
        pthread_join(vozila[i],NULL);
}